/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.TextureAtlasRepository;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.humanoid.HumanoidEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetDictionary;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.rendering.RenderMode;

public class ItemEntityAssetDictionaryProvider
implements Provider<ItemEntityAssetDictionary> {
    private final EntityAssetTypeDictionary entityAssetTypeDictionary;
    private final TextureAtlasRepository textureAtlasRepository;
    private final ItemTypeDictionary itemTypeDictionary;

    @Inject
    public ItemEntityAssetDictionaryProvider(EntityAssetTypeDictionary entityAssetTypeDictionary, TextureAtlasRepository textureAtlasRepository, ItemTypeDictionary itemTypeDictionary) {
        this.entityAssetTypeDictionary = entityAssetTypeDictionary;
        this.textureAtlasRepository = textureAtlasRepository;
        this.itemTypeDictionary = itemTypeDictionary;
    }

    @Override
    public ItemEntityAssetDictionary get() {
        TextureAtlas diffuseTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.DIFFUSE_ENTITIES);
        TextureAtlas normalTextureAtlas = this.textureAtlasRepository.get(TextureAtlasRepository.TextureAtlasType.NORMAL_ENTITIES);
        FileHandle entityDefinitionsFile = Gdx.files.internal("assets/definitions/entityAssets/itemEntityAssets.json");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            List assetList = (List)objectMapper.readValue(entityDefinitionsFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, ItemEntityAsset.class));
            for (ItemEntityAsset asset : assetList) {
                for (SpriteDescriptor spriteDescriptor : asset.getSpriteDescriptors().values()) {
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, diffuseTextureAtlas, RenderMode.DIFFUSE);
                    HumanoidEntityAssetDictionaryProvider.addSprite(spriteDescriptor, normalTextureAtlas, RenderMode.NORMALS);
                }
            }
            return new ItemEntityAssetDictionary(assetList, this.entityAssetTypeDictionary, this.itemTypeDictionary);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

